package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestInProcess;

import javax.annotation.Resource;

public class AppointmentRequestInProcessDataLayerRepo implements AppointmentRequestInProcessDataLayer{

	@Resource
	private AppointmentRequestInProcessDao dao;

	@Override
	public VARAppointmentRequestInProcess fetchAppointmentRequestInProcessByAppointmentRequestId(String appointmentRequestId) {
		return dao.get(appointmentRequestId);
	}

	@Override
    public VARAppointmentRequestInProcess saveAppointmentRequestInProcess(VARAppointmentRequestInProcess appointmentRequestInProcess) {
		return dao.save(appointmentRequestInProcess);
	}

	@Override
	public void deleteAppointmentRequestInProcessByUserId(String userId) {
		dao.deleteByUserId(userId);
	}

	@Override
	public void deleteAppointmentRequestInProcessById(String appointmentRequestId) {
		dao.deleteById(appointmentRequestId);
	}

}
